<?php
/**
 *
 * @link              http://www.dropshippingwordpress.com/
 * @since             1.0.0
 * @package           Dropwp_Generator
 *
 * @wordpress-plugin
 * Plugin Name:       Dropwp Generator
 * Plugin URI:        http://www.dropshippingwordpress.com
 * Description:       WooCommerce shop generator
 * Version:           1.0.0
 * Author:            Dropwp
 * Author URI:        http://www.dropshippingwordpress.com/
 * Text Domain:       dropwp_generator
 * Domain Path:       /languages
 */

$dummy_text = __( 'Dropwp Generator', 'dropwp_generator' );
$dummy_text = __( 'WooCommerce shop generator', 'dropwp_generator' );

require_once dirname( __FILE__ ) . '/class-tgm-plugin-activation.php';

// Ensure dissmissed messages are enabled again
function dropwp_generator_activate() {
	delete_metadata( 'user', null, 'tgmpa_dismissed_notice_dropwp_generator', null, true );
}
register_activation_hook( __FILE__, 'dropwp_generator_activate' );

add_action( 'init', 'dropwp_generator_init' );
function dropwp_generator_init() {
	add_action( 'plugins_loaded', 'dropwp_generator_load_plugin_textdomain' );
	add_filter( 'plugin_action_links_' . plugin_basename(__FILE__), 'dropwp_generator_add_settings_link' );
    add_action( 'admin_enqueue_scripts', 'drowp_genertor_enqueue_styles' );
}

function drowp_genertor_enqueue_styles() {
    wp_register_style( 'dropwp_generator_admin', plugin_dir_url( __FILE__ ) . 'css/dropwp_generator_admin.css' );
    wp_enqueue_style( 'dropwp_generator_admin' );
}

function dropwp_generator_load_plugin_textdomain() {
	load_plugin_textdomain( 'dropwp_generator', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
}

function dropwp_generator_add_settings_link($links) {
	$settings_link = '<a href="plugins.php?page=dropwp_generator">'. __( 'Settings', 'dropwp_generator' ) . '</a>';
	array_push( $links, $settings_link );
	return $links;
}

add_action( 'dropwp_tgmpa_register', 'dropwp_generator_register_required_plugins' );
function dropwp_generator_register_required_plugins() {

	$plugins = array(

        array(
            'name' => 'WooCommerce',
            'slug' => 'woocommerce',
			'required'           => true,
			'force_activation'   => true,
			'force_deactivation' => false,
        ),

        array(
            'name' => 'WooCommerce PDF Invoices & Packing Slips',
            'slug' => 'woocommerce-pdf-invoices-packing-slips',
			'required'           => true,
			'force_activation'   => true,
			'force_deactivation' => false,
        ),

		array(
			'name' => 'Woocommerce Brand',
			'slug' => 'wc-brand',
			'required'           => true,
			'force_activation'   => false,
			'force_deactivation' => false,
		),

		array(
            'name' => 'Asesor de Cookies para normativa española',
            'slug' => 'asesor-cookies-para-la-ley-en-espana',
			'required'           => true,
			'force_activation'   => false,
			'force_deactivation' => false,
        ),

        array(
            'name' => 'User Switching',
            'slug' => 'user-switching',
            'source'             => '',
            'required'           => false,
            'force_activation'   => false,
            'force_deactivation' => false,
            'external_url'       => '',
        ),

        array(
            'name' => 'Duplicate post',
            'slug' => 'duplicate-post',
            'source'             => '',
            'required'           => false,
            'force_activation'   => false,
            'force_deactivation' => false,
            'external_url'       => '',
        ),

        array(
            'name' => 'qTranslate X',
            'slug' => 'qtranslate-x',
            'source'             => '',
            'required'           => false,
            'force_activation'   => false,
            'force_deactivation' => false,
            'external_url'       => '',
        ),

        array(
            'name' => 'All in One SEO Pack & qTranslate-X',
            'slug' => 'all-in-one-seo-pack-qtranslate-x',
            'source'             => '',
            'required'           => false,
            'force_activation'   => false,
            'force_deactivation' => false,
            'external_url'       => '',
        ),

        array(
            'name' => 'WooCommerce & qTranslate-X',
            'slug' => 'woocommerce-qtranslate-x',
            'source'             => '',
            'required'           => false,
            'force_activation'   => false,
            'force_deactivation' => false,
            'external_url'       => '',
        ),

        array(
            'name' => 'Jetpack by WordPress.com',
            'slug' => 'jetpack',
            'source'             => '',
            'required'           => false,
            'force_activation'   => false,
            'force_deactivation' => false,
            'external_url'       => '',
        ),

        array(
            'name' => 'All in One SEO Pack',
            'slug' => 'all-in-one-seo-pack',
            'source'             => '',
            'required'           => true,
            'force_activation'   => true,
            'force_deactivation' => false,
            'external_url'       => '',
        ),

		array(
			'name'               => 'Dropwp NIF',
			'slug'               => 'dropwp_nif',
			'source'             => 'http://www.dropshippingwordpress.com/download/515/',
			'required'           => true,
			'force_activation'   => true,
			'force_deactivation' => false,
			'external_url'		 => 'http://www.dropshippingwordpress.com/dropwp-nif-plugin-de-woocommerce-para-anadir-nif-a-los-clientes/',
		),

		array(
			'name'         => 'Woo Weight Shipping',
			'slug'         => 'woo-weight-shipping',
			'source'       => 'https://github.com/acanza/woo-weight-shipping/archive/master.zip',
			'required'     => false,
			'external_url' => 'https://github.com/acanza/woo-weight-shipping',
		),

	);

	$config = array(
		'id'           => 'dropwp_generator',
		'default_path' => '',
		'menu'         => 'dropwp_generator',
		'parent_slug'  => 'plugins.php',
		'capability'   => 'manage_options',
		'has_notices'  => true,
		'dismissable'  => true,
		'dismiss_msg'  => '',
		'is_automatic' => true,
		'message'      => '',

		'strings'      => array(
			'page_title'                      => __( 'Dropwp Generator: Install Required Plugins', 'dropwp_generator' ),
			'menu_title'                      => __( 'Dropwp Generator', 'dropwp_generator' ),
			'installing'                      => __( 'Installing Plugin: %s', 'dropwp_generator' ), // %s = plugin name.
			'oops'                            => __( 'Something went wrong with the plugin API.', 'dropwp_generator' ),
			'notice_can_install_required'     => _n_noop(
				'Dropwp Generator requires the following plugin: %1$s.',
				'Dropwp Generator requires the following plugins: %1$s.',
				'dropwp_generator'
			), // %1$s = plugin name(s).
			'notice_can_install_recommended'  => _n_noop(
				'Dropwp Generator recommends the following plugin: %1$s.',
				'Dropwp Generator recommends the following plugins: %1$s.',
				'dropwp_generator'
			), // %1$s = plugin name(s).
			'notice_cannot_install'           => _n_noop(
				'Sorry, but you do not have the correct permissions to install the %1$s plugin.',
				'Sorry, but you do not have the correct permissions to install the %1$s plugins.',
				'dropwp_generator'
			), // %1$s = plugin name(s).
			'notice_ask_to_update'            => _n_noop(
				'The following plugin needs to be updated to its latest version to ensure maximum compatibility with Dropwp Generator: %1$s.',
				'The following plugins need to be updated to their latest version to ensure maximum compatibility with Dropwp Generator: %1$s.',
				'dropwp_generator'
			), // %1$s = plugin name(s).
			'notice_ask_to_update_maybe'      => _n_noop(
				'There is an update available for: %1$s.',
				'There are updates available for the following plugins: %1$s.',
				'dropwp_generator'
			), // %1$s = plugin name(s).
			'notice_cannot_update'            => _n_noop(
				'Sorry, but you do not have the correct permissions to update the %1$s plugin.',
				'Sorry, but you do not have the correct permissions to update the %1$s plugins.',
				'dropwp_generator'
			), // %1$s = plugin name(s).
			'notice_can_activate_required'    => _n_noop(
				'The following required plugin is currently inactive: %1$s.',
				'The following required plugins are currently inactive: %1$s.',
				'dropwp_generator'
			), // %1$s = plugin name(s).
			'notice_can_activate_recommended' => _n_noop(
				'The following recommended plugin is currently inactive: %1$s.',
				'The following recommended plugins are currently inactive: %1$s.',
				'dropwp_generator'
			), // %1$s = plugin name(s).
			'notice_cannot_activate'          => _n_noop(
				'Sorry, but you do not have the correct permissions to activate the %1$s plugin.',
				'Sorry, but you do not have the correct permissions to activate the %1$s plugins.',
				'dropwp_generator'
			), // %1$s = plugin name(s).
			'install_link'                    => _n_noop(
				'Begin installing plugin',
				'Begin installing plugins',
				'dropwp_generator'
			),
			'update_link' 					  => _n_noop(
				'Begin updating plugin',
				'Begin updating plugins',
				'dropwp_generator'
			),
			'activate_link'                   => _n_noop(
				'Begin activating plugin',
				'Begin activating plugins',
				'dropwp_generator'
			),
			'return'                          => __( 'Return to Required Plugins Installer', 'dropwp_generator' ),
			'plugin_activated'                => __( 'Plugin activated successfully.', 'dropwp_generator' ),
			'activated_successfully'          => __( 'The following plugin was activated successfully:', 'dropwp_generator' ),
			'plugin_already_active'           => __( 'No action taken. Plugin %1$s was already active.', 'dropwp_generator' ),  // %1$s = plugin name(s).
			'plugin_needs_higher_version'     => __( 'Plugin not activated. A higher version of %s is needed for Dropwp Generator. Please update the plugin.', 'dropwp_generator' ),  // %1$s = plugin name(s).
			'complete'                        => __( 'All plugins installed and activated successfully. %1$s', 'dropwp_generator' ), // %s = dashboard link.
			'dismiss'                         => __( 'Dismiss this notice', 'dropwp_generator' ),
			'contact_admin'                   => __( 'Please contact the administrator of this site for help.', 'dropwp_generator' ),

			'nag_type'                        => 'updated',
		),

	);

	dropwp_tgmpa( $plugins, $config );
}
