<?php

if ( ! defined( 'ABSPATH' ) ) exit;

/**
 *
 * @link              http://www.dropshippingwordpress.com/
 * @since             1.0.0
 * @package           Dropwp_NIF
 *
 * @wordpress-plugin
 * Plugin Name:       Dropwp NIF
 * Plugin URI:        http://www.dropshippingwordpress.com/
 * Description:       Add NIF to billing address.
 * Version:           1.0.0
 * Author:            Dropwp
 * Author URI:        http://www.dropshippingwordpress.com/
 * Text Domain:       dropwp_nif
 * Domain Path:       /languages
 */

if ( !defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
if ( !in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) )
	return;

if ( !class_exists( 'Dropwp_NIF' ) ) {

	final class Dropwp_NIF {

		public $version = '1.0.0';

		protected static $_instance = null;

		public static function instance() {
			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
			}
			return self::$_instance;
		}

		public function __construct() {
			load_plugin_textdomain( 'dropwp_nif', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );

			add_filter( 'woocommerce_billing_fields' , array( $this, 'woocommerce_billing_fields' ), 10, 2 );
			add_filter( 'woocommerce_my_account_my_address_formatted_address', array( $this, 'woocommerce_my_account_my_address_formatted_address' ), 10, 3 );
			add_filter( 'woocommerce_localisation_address_formats', array( $this, 'woocommerce_localisation_address_formats' ) );
			add_filter( 'woocommerce_formatted_address_replacements', array( $this, 'woocommerce_formatted_address_replacements' ), 10, 2 );
			add_filter( 'woocommerce_order_formatted_billing_address', array( $this, 'woocommerce_order_formatted_billing_address' ), 10, 2 );

			add_filter( 'woocommerce_customer_meta_fields', array( $this, 'woocommerce_customer_meta_fields' ) );
			add_filter( 'woocommerce_admin_billing_fields', array( $this, 'woocommerce_admin_billing_fields' ) );
		}

		public function woocommerce_localisation_address_formats($address_formats) {
			$address_formats['ES'] = "\n{name}\n{vat_number}\n{company}\n{address_1}\n{address_2}\n{postcode} {city}\n{country}";
			return $address_formats;
		}

		public function woocommerce_billing_fields( $fields, $country ) {
			$new_field = array(
				'billing_vat_number' => array(
					'label'     => __('NIF', 'dropwp_nif'),
					'placeholder'   => '',
					'required'  => true,
					'class'     => array('form-row-wide'),
					'clear'     => true
				)
			);

			return array_merge( array_slice( $fields, 0, 2 ), $new_field, array_slice( $fields, 2 ) );
		}

		public function woocommerce_my_account_my_address_formatted_address( $fields, $customer_id, $name ) {
			$fields[] = array(
				'vat_number' => get_user_meta( $customer_id, $name . '_vat_number', true ),
			);

			return $fields;
		}

		public function woocommerce_formatted_address_replacements( $replace, $args) {
			$replace[] = array(
	     	    '{vat_number}' => (isset($args['vat_number']) && $args['vat_number'] != '') ? $args['vat_number'] : '',
				'{vat_number_upper}' => strtoupper((isset($args['vat_number']) && $args['vat_number'] != '') ? __('NIF: ', 'dropwp_nif') . $args['vat_number'] : ''),
			);

			return $replace;
		}

		public function woocommerce_order_formatted_billing_address($address, $order) {
			$address[] = array(
				'vat_number'	=> $order->billing_vat_number,
			);

			return $address;
		}

		public function plugin_url() {
			return untrailingslashit( plugins_url( '/', __FILE__ ) );
		}

		public function woocommerce_customer_meta_fields($fields) {
			$fields['billing']['fields'][] = array(
				'billing_vat_number' => array(
					'label' => __('NIF', 'dropwp_nif'),
					'description' => ''
				),
			);
			return $fields;
		}

		public function woocommerce_admin_billing_fields ($fields) {
			$fields[] = array(
				'vat_number' => array(
					'label'     => __('NIF', 'dropwp_nif'),
					'show'   => false
				),
			);

			return $fields;
		}

	}

}

Dropwp_NIF::instance();
